/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.RegionFile;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.BaseDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class DeletionTimeOut
extends BaseDeletionTask {
    ChunkPos center;
    int radius;
    long timeOut;
    long cachedSize = -1L;

    public DeletionTimeOut(CompoundTag nbt) {
        super(nbt);
        this.center = new ChunkPos(nbt.m_128454_("center"));
        this.radius = nbt.m_128451_("radius");
        this.timeOut = nbt.m_128454_("time");
        this.cachedSize = nbt.m_128441_("cache") ? nbt.m_128454_("cache") : -1L;
    }

    public DeletionTimeOut(String name, ResourceKey<Level> type, ChunkPos center, int radius, long timeOut) {
        super(name, type);
        this.center = center;
        this.radius = radius;
        this.timeOut = timeOut;
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = super.write();
        nbt.m_128405_("radius", this.radius);
        nbt.m_128356_("time", this.timeOut);
        nbt.m_128356_("center", this.center.m_45588_());
        if (this.cachedSize != -1L) {
            nbt.m_128356_("cache", this.cachedSize);
        }
        return nbt;
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    public String getShapeName() {
        return "TimeOut";
    }

    @Override
    public long getTaskSize() {
        return this.cachedSize == -1L ? (this.cachedSize = this.calculateCacheSize()) : this.cachedSize;
    }

    @Override
    public void append(MutableComponent builder) {
        ITask.convert("Type=Cleanup, ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("Timout=" + this.timeOut + ", ", builder, ChatFormatting.DARK_PURPLE);
        ITask.convert("X=" + this.center.f_45578_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("Z=" + this.center.f_45579_ + ", ", builder, ChatFormatting.YELLOW);
        ITask.convert("MinRadius=" + this.radius, builder, ChatFormatting.BLUE);
    }

    @Override
    public ChunkDeleter createTask(ServerLevel world, IProcess.PrepaireProgress progress) {
        ObjectArrayList list = new ObjectArrayList();
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        progress.setMax((long)this.getRegionFiles().size() * 1024L);
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.f_45578_;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.f_45579_;
            if (minX < -this.radius || minX + 32 > this.radius || minZ < -this.radius || minZ + 32 > this.radius) {
                list.add(service.submit(() -> {
                    if (!progress.isAlive()) {
                        return new ScanResult(ChunkPos.m_45589_((int)(minX >> 5), (int)(minZ >> 5)), new BitSet());
                    }
                    long result = ChunkPos.m_45589_((int)(minX >> 5), (int)(minZ >> 5));
                    BitSet set = new BitSet(1024);
                    try (RegionFile region = new RegionFile(subFile, subFile.getParent(), false);){
                        for (int i = 0; i < 1024 && progress.isAlive(); ++i) {
                            int x = i % 32 + minX;
                            int z = i / 32 + minZ;
                            ChunkPos pos = new ChunkPos(i % 32, i / 32);
                            if ((x > this.radius || x < -this.radius || z > this.radius || z < -this.radius) && region.m_63682_(pos) && this.canBeDeleted(region, pos)) {
                                set.set(i);
                            }
                            progress.growValue(1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new ScanResult(result, set);
                }));
                continue;
            }
            progress.growValue(1024);
        }
        service.shutdown();
        Long2ObjectOpenHashMap toDelete = new Long2ObjectOpenHashMap();
        long total = 0L;
        while (progress.isAlive() && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!((Future)list.get(i)).isDone()) continue;
                try {
                    ((ScanResult)((Future)list.remove(i--)).get()).apply((Long2ObjectMap<BitSet>)toDelete);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        if (!progress.isAlive() && list.size() > 0) {
            for (Future entry : list) {
                entry.cancel(true);
            }
            service.shutdownNow();
        }
        this.cachedSize = total;
        return new ChunkDeleter((ResourceKey<Level>)this.type, this.getSaveFile(), world).init((Long2ObjectMap<BitSet>)toDelete, this.center, progress);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canBeDeleted(RegionFile file, ChunkPos pos) {
        try (DataInputStream stream = file.m_63645_(pos);){
            if (stream == null) return false;
            CompoundTag nbt = NbtIo.m_128928_((DataInput)stream);
            boolean bl = nbt != null && (ChunkSerializer.m_63485_((CompoundTag)nbt) == ChunkStatus.ChunkType.PROTOCHUNK || nbt.m_128469_("Level").m_128454_("InhabitedTime") <= this.timeOut);
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private long calculateCacheSize() {
        long total = 0L;
        for (Path subFile : this.getRegionFiles()) {
            String[] name = subFile.getFileName().toString().split("\\.");
            int minX = (Integer.parseInt(name[1]) << 5) - this.center.f_45578_;
            int minZ = (Integer.parseInt(name[2]) << 5) - this.center.f_45579_;
            if (minX >= -this.radius && minX + 32 <= this.radius && minZ >= -this.radius && minZ + 32 <= this.radius) continue;
            try (RegionFile file = new RegionFile(subFile, subFile.getParent(), false);){
                for (int i = 0; i < 1024; ++i) {
                    int x = i % 32 + minX;
                    int z = i / 32 + minZ;
                    if (x <= this.radius && x >= -this.radius && z <= this.radius && z >= -this.radius || !file.m_63682_(new ChunkPos(i % 32, i / 32))) continue;
                    ++total;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return total;
    }

    static class ScanResult {
        long pos;
        BitSet set;

        public ScanResult(long pos, BitSet set) {
            this.pos = pos;
            this.set = set;
        }

        public long apply(Long2ObjectMap<BitSet> map) {
            if (!this.set.isEmpty()) {
                map.put(this.pos, (Object)this.set);
                return this.set.cardinality();
            }
            return 0L;
        }
    }
}

